/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.ForgeHooksClient;

public class FluidRenderer {
    public static boolean render(BlockAndTintGetter blockAccess, BlockPos pos, VertexConsumer iVertexBuilder, FluidState fluidState) {
        float waterDepth;
        boolean isWaterEast;
        boolean isLava = fluidState.m_205070_(FluidTags.f_13132_);
        TextureAtlasSprite[] atextureatlassprite = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)blockAccess, (BlockPos)pos, (FluidState)fluidState);
        int color = fluidState.m_76152_().getAttributes().getColor(blockAccess, pos);
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        boolean isWaterUp = !FluidRenderer.isAdjacentFluidSameAs((BlockGetter)blockAccess, pos, Direction.UP, fluidState);
        boolean isWaterDown = !FluidRenderer.isAdjacentFluidSameAs((BlockGetter)blockAccess, pos, Direction.DOWN, fluidState) && !FluidRenderer.needsSideRendering((BlockGetter)blockAccess, pos, Direction.DOWN, 0.8888889f);
        boolean isWaterNorth = !FluidRenderer.isAdjacentFluidSameAs((BlockGetter)blockAccess, pos, Direction.NORTH, fluidState);
        boolean isWaterSouth = !FluidRenderer.isAdjacentFluidSameAs((BlockGetter)blockAccess, pos, Direction.SOUTH, fluidState);
        boolean isWaterWest = !FluidRenderer.isAdjacentFluidSameAs((BlockGetter)blockAccess, pos, Direction.WEST, fluidState);
        boolean bl = isWaterEast = !FluidRenderer.isAdjacentFluidSameAs((BlockGetter)blockAccess, pos, Direction.EAST, fluidState);
        if (!(isWaterUp || isWaterDown || isWaterEast || isWaterWest || isWaterNorth || isWaterSouth)) {
            return false;
        }
        boolean needDepthRendering = false;
        float fluidHeight = FluidRenderer.getFluidHeight((BlockGetter)blockAccess, pos, fluidState.m_76152_());
        float fluidHeightS = FluidRenderer.getFluidHeight((BlockGetter)blockAccess, pos.m_142128_(), fluidState.m_76152_());
        float fluidHeightSE = FluidRenderer.getFluidHeight((BlockGetter)blockAccess, pos.m_142126_().m_142128_(), fluidState.m_76152_());
        float fluidHeightE = FluidRenderer.getFluidHeight((BlockGetter)blockAccess, pos.m_142126_(), fluidState.m_76152_());
        float posX = pos.m_123341_();
        float posY = pos.m_123342_();
        float posZ = pos.m_123343_();
        float f = waterDepth = isWaterDown ? 0.001f : 0.0f;
        if (isWaterUp && !FluidRenderer.needsSideRendering((BlockGetter)blockAccess, pos, Direction.UP, Math.min(Math.min(fluidHeight, fluidHeightS), Math.min(fluidHeightSE, fluidHeightE)))) {
            float f20;
            float f16;
            float f19;
            float f15;
            float f18;
            float f14;
            float f17;
            float f13;
            needDepthRendering = true;
            fluidHeight -= 0.001f;
            fluidHeightS -= 0.001f;
            fluidHeightSE -= 0.001f;
            fluidHeightE -= 0.001f;
            Vec3 vec3d = fluidState.m_76179_((BlockGetter)blockAccess, pos);
            if (vec3d.f_82479_ == 0.0 && vec3d.f_82481_ == 0.0) {
                TextureAtlasSprite textureatlassprite1 = atextureatlassprite[0];
                f13 = textureatlassprite1.m_118367_(0.0);
                f17 = textureatlassprite1.m_118393_(0.0);
                f14 = f13;
                f18 = textureatlassprite1.m_118393_(16.0);
                f15 = textureatlassprite1.m_118367_(16.0);
                f19 = f18;
                f16 = f15;
                f20 = f17;
            } else {
                TextureAtlasSprite textureatlassprite = atextureatlassprite[1];
                float f21 = (float)Mth.m_14136_((double)vec3d.f_82481_, (double)vec3d.f_82479_) - 1.5707964f;
                float f22 = Mth.m_14031_((float)f21) * 0.25f;
                float f23 = Mth.m_14089_((float)f21) * 0.25f;
                f13 = textureatlassprite.m_118367_((double)(8.0f + (-f23 - f22) * 16.0f));
                f17 = textureatlassprite.m_118393_((double)(8.0f + (-f23 + f22) * 16.0f));
                f14 = textureatlassprite.m_118367_((double)(8.0f + (-f23 + f22) * 16.0f));
                f18 = textureatlassprite.m_118393_((double)(8.0f + (f23 + f22) * 16.0f));
                f15 = textureatlassprite.m_118367_((double)(8.0f + (f23 + f22) * 16.0f));
                f19 = textureatlassprite.m_118393_((double)(8.0f + (f23 - f22) * 16.0f));
                f16 = textureatlassprite.m_118367_((double)(8.0f + (f23 - f22) * 16.0f));
                f20 = textureatlassprite.m_118393_((double)(8.0f + (-f23 - f22) * 16.0f));
            }
            float f43 = (f13 + f14 + f15 + f16) / 4.0f;
            float f44 = (f17 + f18 + f19 + f20) / 4.0f;
            float f45 = (float)atextureatlassprite[0].m_118405_() / (atextureatlassprite[0].m_118410_() - atextureatlassprite[0].m_118409_());
            float f46 = (float)atextureatlassprite[0].m_118408_() / (atextureatlassprite[0].m_118412_() - atextureatlassprite[0].m_118411_());
            float f47 = 4.0f / Math.max(f46, f45);
            f13 = Mth.m_14179_((float)f47, (float)f13, (float)f43);
            f14 = Mth.m_14179_((float)f47, (float)f14, (float)f43);
            f15 = Mth.m_14179_((float)f47, (float)f15, (float)f43);
            f16 = Mth.m_14179_((float)f47, (float)f16, (float)f43);
            f17 = Mth.m_14179_((float)f47, (float)f17, (float)f44);
            f18 = Mth.m_14179_((float)f47, (float)f18, (float)f44);
            f19 = Mth.m_14179_((float)f47, (float)f19, (float)f44);
            f20 = Mth.m_14179_((float)f47, (float)f20, (float)f44);
            int j = FluidRenderer.getLight(blockAccess, pos);
            float f25 = 1.0f * red;
            float f26 = 1.0f * green;
            float f27 = 1.0f * blue;
            FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeight, posZ + 0.0f, f25, f26, f27, alpha, f13, f17, j);
            FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeightS, posZ + 1.0f, f25, f26, f27, alpha, f14, f18, j);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightSE, posZ + 1.0f, f25, f26, f27, alpha, f15, f19, j);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightE, posZ + 0.0f, f25, f26, f27, alpha, f16, f20, j);
            if (fluidState.m_76171_((BlockGetter)blockAccess, pos.m_7494_())) {
                FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeight, posZ + 0.0f, f25, f26, f27, alpha, f13, f17, j);
                FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightE, posZ + 0.0f, f25, f26, f27, alpha, f16, f20, j);
                FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + fluidHeightSE, posZ + 1.0f, f25, f26, f27, alpha, f15, f19, j);
                FluidRenderer.vertex(iVertexBuilder, posX + 0.0f, posY + fluidHeightS, posZ + 1.0f, f25, f26, f27, alpha, f14, f18, j);
            }
        }
        if (isWaterDown) {
            float f34 = atextureatlassprite[0].m_118409_();
            float f35 = atextureatlassprite[0].m_118410_();
            float f37 = atextureatlassprite[0].m_118411_();
            float f39 = atextureatlassprite[0].m_118412_();
            int i1 = FluidRenderer.getLight(blockAccess, pos.m_7495_());
            float f40 = 0.5f * red;
            float f41 = 0.5f * green;
            float f42 = 0.5f * blue;
            FluidRenderer.vertex(iVertexBuilder, posX, posY + waterDepth, posZ + 1.0f, f40, f41, f42, alpha, f34, f39, i1);
            FluidRenderer.vertex(iVertexBuilder, posX, posY + waterDepth, posZ, f40, f41, f42, alpha, f34, f37, i1);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + waterDepth, posZ, f40, f41, f42, alpha, f35, f37, i1);
            FluidRenderer.vertex(iVertexBuilder, posX + 1.0f, posY + waterDepth, posZ + 1.0f, f40, f41, f42, alpha, f35, f39, i1);
            needDepthRendering = true;
        }
        for (int l = 0; l < 4; ++l) {
            Block block;
            boolean connectingWater;
            Direction direction;
            float offsetZ;
            float z;
            float offsetX;
            float x;
            float fHeight;
            float height;
            if (l == 0) {
                height = fluidHeight;
                fHeight = fluidHeightE;
                x = posX;
                offsetX = posX + 1.0f;
                z = posZ + 0.001f;
                offsetZ = posZ + 0.001f;
                direction = Direction.NORTH;
                connectingWater = isWaterNorth;
            } else if (l == 1) {
                height = fluidHeightSE;
                fHeight = fluidHeightS;
                x = posX + 1.0f;
                offsetX = posX;
                z = posZ + 1.0f - 0.001f;
                offsetZ = posZ + 1.0f - 0.001f;
                direction = Direction.SOUTH;
                connectingWater = isWaterSouth;
            } else if (l == 2) {
                height = fluidHeightS;
                fHeight = fluidHeight;
                x = posX + 0.001f;
                offsetX = posX + 0.001f;
                z = posZ + 1.0f;
                offsetZ = posZ;
                direction = Direction.WEST;
                connectingWater = isWaterWest;
            } else {
                height = fluidHeightE;
                fHeight = fluidHeightSE;
                x = posX + 1.0f - 0.001f;
                offsetX = posX + 1.0f - 0.001f;
                z = posZ;
                offsetZ = posZ + 1.0f;
                direction = Direction.EAST;
                connectingWater = isWaterEast;
            }
            if (!connectingWater || FluidRenderer.needsSideRendering((BlockGetter)blockAccess, pos, direction, Math.max(height, fHeight))) continue;
            needDepthRendering = true;
            BlockPos blockpos = pos.m_142300_(direction);
            TextureAtlasSprite textureatlassprite2 = atextureatlassprite[1];
            if (!isLava && ((block = blockAccess.m_8055_(blockpos).m_60734_()) == Blocks.f_50058_ || block instanceof StainedGlassBlock)) {
                textureatlassprite2 = ModelBakery.f_119223_.m_119204_();
            }
            float f48 = textureatlassprite2.m_118367_(0.0);
            float f49 = textureatlassprite2.m_118367_(8.0);
            float f50 = textureatlassprite2.m_118393_((double)((1.0f - height) * 16.0f * 0.5f));
            float f28 = textureatlassprite2.m_118393_((double)((1.0f - fHeight) * 16.0f * 0.5f));
            float f29 = textureatlassprite2.m_118393_(8.0);
            int k = FluidRenderer.getLight(blockAccess, blockpos);
            float f30 = l < 2 ? 0.8f : 0.6f;
            float r = 1.0f * f30 * red;
            float g = 1.0f * f30 * green;
            float b = 1.0f * f30 * blue;
            FluidRenderer.vertex(iVertexBuilder, x, posY + height, z, r, g, b, alpha, f48, f50, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + fHeight, offsetZ, r, g, b, alpha, f49, f28, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + waterDepth, offsetZ, r, g, b, alpha, f49, f29, k);
            FluidRenderer.vertex(iVertexBuilder, x, posY + waterDepth, z, r, g, b, alpha, f48, f29, k);
            if (textureatlassprite2 == ModelBakery.f_119223_.m_119204_()) continue;
            FluidRenderer.vertex(iVertexBuilder, x, posY + waterDepth, z, r, g, b, alpha, f48, f29, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + waterDepth, offsetZ, r, g, b, alpha, f49, f29, k);
            FluidRenderer.vertex(iVertexBuilder, offsetX, posY + fHeight, offsetZ, r, g, b, alpha, f49, f28, k);
            FluidRenderer.vertex(iVertexBuilder, x, posY + height, z, r, g, b, alpha, f48, f50, k);
        }
        return needDepthRendering;
    }

    private static boolean isAdjacentFluidSameAs(BlockGetter blockAccess, BlockPos pos, Direction direction, FluidState fluid) {
        BlockPos blockpos = pos.m_142300_(direction);
        FluidState ifluidstate = blockAccess.m_6425_(blockpos);
        return ifluidstate.m_76152_().m_6212_(fluid.m_76152_());
    }

    private static void vertex(VertexConsumer iVertexBuilder, float x, float y, float z, float red, float green, float blue, float alpha, float textX, float textY, int light) {
        iVertexBuilder.m_5483_((double)x, (double)y, (double)z).m_85950_(red, green, blue, alpha).m_7421_(textX, textY).m_85969_(light).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static int getLight(BlockAndTintGetter p_228795_1_, BlockPos p_228795_2_) {
        int i = LevelRenderer.m_109541_((BlockAndTintGetter)p_228795_1_, (BlockPos)p_228795_2_);
        int j = LevelRenderer.m_109541_((BlockAndTintGetter)p_228795_1_, (BlockPos)p_228795_2_.m_7494_());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(i1, j1) << 16;
    }

    private static boolean needsSideRendering(BlockGetter blockAccess, BlockPos pos, Direction direction, float fluidHeight) {
        BlockPos blockpos = pos.m_142300_(direction);
        BlockState blockstate = blockAccess.m_8055_(blockpos);
        if (blockstate.m_60815_()) {
            VoxelShape voxelshape = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidHeight, (double)1.0);
            VoxelShape voxelshape1 = blockstate.m_60816_(blockAccess, blockpos);
            return Shapes.m_83117_((VoxelShape)voxelshape, (VoxelShape)voxelshape1, (Direction)direction);
        }
        return false;
    }

    private static float getFluidHeight(BlockGetter blockAccess, BlockPos pos, Fluid fluid) {
        int occurances = 0;
        float totalHeight = 0.0f;
        for (int j = 0; j < 4; ++j) {
            BlockPos blockpos = pos.m_142082_(-(j & 1), 0, -(j >> 1 & 1));
            if (blockAccess.m_6425_(blockpos.m_7494_()).m_76152_().m_6212_(fluid)) {
                return 1.0f;
            }
            FluidState ifluidstate = blockAccess.m_6425_(blockpos);
            if (ifluidstate.m_76152_().m_6212_(fluid)) {
                float f1 = ifluidstate.m_76155_(blockAccess, blockpos);
                if (f1 >= 0.8f) {
                    totalHeight += f1 * 10.0f;
                    occurances += 10;
                    continue;
                }
                totalHeight += f1;
                ++occurances;
                continue;
            }
            if (blockAccess.m_8055_(blockpos).m_60767_().m_76333_()) continue;
            ++occurances;
        }
        return occurances > 0 ? totalHeight / (float)occurances : 0.0f;
    }
}

